{-------------------------------------------------------------------------------

   DO OBSUGI PLIKU:

   NAZWA_PLIKU_INI = 'APP.INI';


-------------------------------------------------------------------------------}
unit UIniFile;

interface
uses
   Windows, SysUtils, Dialogs, StdCtrls, IniFiles, Classes;

type

// ta klasa stanowi nasze opakowanie dla klasy TIniFile
MIniFile = class(TObject)
private
   ini_file  : TIniFile;

private
   // dopisz sekcje w razie gdy plik nie istnieje
   procedure  Dopisz_sekcje();
	procedure  Dopisz_sekcje_vat();


public
	ItemsKeys : TStringList;

   // sprawdza czy sekcja istnieje
   function    Sekcja_istnieje(nazwa_sekcji: String): Boolean;

	{
   procedure UpdateFile(); virtual;
   }

   function  Count() : Integer;
   procedure Wczytaj_el_sekcji(nazwa_sekcji: String);


   procedure   Dopisz_do_sekcji_AsString(Nazwa_sekcji       : String;
                                      const Identyfikator: String;
                                      const Default_Value: String);


   // zwraca warto podanego indentyfikatora ze wskazanej sekcji
   function    Daj_z_sekcji_AsString(Nazwa_sekcji       : String;
                                     const Identyfikator: String;
                                     const Default_Value: String): String;

   // jeeli identyfikatora w sekcji nie byo zostaje dopisany
   procedure   Zapisz_w_sekcji_AsString(nazwa_sekcji       : String;
                                        const identyfikator: String;
                                        const Value        : String);

   procedure   Sprawdz_wszystkie_sekcje();

   constructor Create(fn: String);
   destructor  Destroy(); override;
end;

implementation
{------------------------------------------------------------------------------}
function MIniFile.Count: Integer;
begin

end;

constructor MIniFile.Create(fn: String);
var
   plik : TextFile;

begin
   if not FileExists(fn) then
   begin
      AssignFile(plik, fn);
      Rewrite(plik);
      CloseFile(plik);

      ini_file := TIniFile.Create(fn);
      dopisz_sekcje();
      FreeAndNil(ini_file);
   end
   else begin
      ini_file := TIniFile.Create(fn);
      if not sekcja_istnieje('CENNIK') then
      begin
         dopisz_sekcje();
      end;
      FreeAndNil(ini_file);
   end;

   ini_file := TIniFile.Create(fn);
end;

destructor MIniFile.Destroy();
begin
   FreeAndNil(ini_file);

   inherited destroy();
end;

procedure MIniFile.Dopisz_do_sekcji_AsString(Nazwa_sekcji: String;
  const Identyfikator, Default_Value: String);
begin

end;

procedure MIniFile.Dopisz_sekcje();
begin
   if not ini_file.SectionExists('CENNIK') then begin
      ini_file.WriteString('CENNIK', 'STARTPAGE', '1');
   end;
end;

function MIniFile.Sekcja_istnieje(nazwa_sekcji: String): Boolean;
begin
   Result := ini_file.SectionExists(nazwa_sekcji);
end;

procedure MIniFile.Sprawdz_wszystkie_sekcje;
begin

end;

procedure MIniFile.Wczytaj_el_sekcji(nazwa_sekcji: String);
begin

end;

function MIniFile.Daj_z_sekcji_AsString(Nazwa_sekcji: String;
                                        const Identyfikator: String;
                                        const Default_Value: String): String;

var
   Res : String;

begin
   res := ini_file.ReadString(nazwa_sekcji, identyfikator, default_value);

   Result := res;
end;

procedure MIniFile.Zapisz_w_sekcji_AsString(nazwa_sekcji: String;
                                            const identyfikator: String;
                                            const Value: String);
begin
   ini_file.WriteString(nazwa_sekcji, identyfikator, Value);
end;

procedure MIniFile.Dopisz_sekcje_vat();
begin
	if not ini_file.SectionExists('VAT') then
   begin
   	ini_file.WriteString('VAT', 'PODATEK_1', '0');
      ini_file.WriteString('VAT', 'PODATEK_2', '7');
      ini_file.WriteString('VAT', 'PODATEK_3', '22');
      ini_file.WriteString('VAT', 'PODATEK_4', 'ZW');
   end;
end;

end.

